using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Application_Monitor
{
    /// <summary>
    /// Serial port settings are captured using this form
    /// </summary>
    public partial class frmComPortSettings : Form
    {
        public frmComPortSettings()
        {
            InitializeComponent();
        }

        #region Private Function(s) Declaration

        /// <summary>
        /// This is used to populate the available com ports on the system
        /// </summary>
        private void GetComports()
        {
            string[] strPortNames = System.IO.Ports.SerialPort.GetPortNames();
            foreach (string strPortName in strPortNames)
            {
                cmbComPort.Items.Add(strPortName);
            }
        }
        #endregion

        #region Private Event(s) Declaration
        private void frmComPortSettings_Load(object sender, EventArgs e)
        {
            this.AcceptButton = btnOK;
            this.CancelButton = btnCancel;
            //Get the com port settings from Configuration file
          int  intbaudRate = Convert.ToInt32(System.Configuration.ConfigurationSettings.AppSettings["BaudRate"]);
          int intDataBits = Convert.ToInt32(System.Configuration.ConfigurationSettings.AppSettings["DataBits"]);
          int  intStopBits = Convert.ToInt32(System.Configuration.ConfigurationSettings.AppSettings["StopBits"]);          
          string  strParity = System.Configuration.ConfigurationSettings.AppSettings["Parity"];

          lblBaudRatevalue.Text = intbaudRate.ToString();
          lblDBValue.Text = intDataBits.ToString();
          lblSBValue.Text = intStopBits.ToString();
          lblParityValue.Text = strParity.ToString();

          GetComports();
        }       

        private void btnCancel_Click(object sender, EventArgs e)
        {
            //Closes the form
            this.Close();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (cmbComPort.SelectedIndex == -1)
            {
                MessageBox.Show("Please select a Com Port");

            }
            else
            {
                //Assign the Com port settings
                RS_232_Communication objRS232 = new RS_232_Communication();
                objRS232.ComPort = cmbComPort.SelectedItem.ToString();
                objRS232.BaudRate = Convert.ToInt32(lblBaudRatevalue.Text);
                objRS232.DataBits = Convert.ToInt32(lblDBValue.Text);
                objRS232.SBits = Convert.ToInt32(lblSBValue.Text);
                objRS232.ParityValue = lblParityValue.Text;

                //frmPulseOximetryOnline objPulse = new frmPulseOximetryOnline();
                //this.Close();
                //objPulse.RS232Communication = objRS232;
                //objPulse.ShowDialog();
                this.Hide();
                frmPulseOximetryOnlineSigned objPulse = new frmPulseOximetryOnlineSigned();
                
                objPulse.RS232Communication = objRS232;
                objPulse.ShowDialog();
                this.Close();
            }
        }
        #endregion

    }
}